
#ifndef Massenger_h
#define Massenger_h
#define MASSENGERBUFFERSIZE 128
#define MASSENGERBUFFERLAST 127
#define MASSENGERBUFFERSAFE 126

#if defined(ARDUINO) && ARDUINO >= 100
#include "Arduino.h"
#else
#include "WProgram.h"
#endif



extern "C" {
// callback function
    typedef void (*massengerCallbackFunction)(void);
}


class Massenger
{

public:

  Massenger(Stream * serial , massengerCallbackFunction callback); 
  uint8_t checkAddr(char *string);
  int getInt();
  //long readLong(); // Added based on a suggestion by G. Paolo Sani
  //char readChar();
  //double readDouble(); // Added based on a suggestion by Lorenzo C.
  //void copyString(char *string, uint8_t size);
  //uint8_t checkString(char *string);
  void update();
  //uint8_t available();
  //
  void send(char *string, int value);
  //void done();
  //void send(char *string);
  //void send(int value);
  
private:
  //void init(char separator);
  void process(int serialByte);
  //uint8_t next();
  void reset();
  //void attach();
  //uint8_t messageState;
  
  massengerCallbackFunction callback;
  
  //char* head; // Pointer to head
  char* tail; // Pointer to tail
  char* last;
  
  Stream* serial;
  
  char token[2];
  //uint8_t dumped;
  
  uint8_t bufferIndex; // Index where to write the data
  char buffer[MASSENGERBUFFERSIZE]; // Buffer that holds the data
  //uint8_t bufferLength; // The length of the buffer (defaults to 64)
  //uint8_t bufferLastIndex; // The last index of the buffer
};

#endif

